define(['backbone'], function(Backbone) {
    'use strict';

    var MISSING_CLINIC_NAME = 'CLINIC NAME NOT FOUND';
    var MISSING_LOCATION_NAME = '';


    //     "siteCode" : "523",
    //     "clinicId" : "64",
    //     "clinicName" : "BO RHEUM DUBREUIL",
    //     "clinicFriendlyLocationName" : "Audiology Clinic",
    //     "primaryStopCode" : "203",
    //     "secondaryStopCode" : "350",
    //     "directSchedulingFlag" : "Y",
    //     "displayToPatientFlag" : "Y",
    //     "institutionName" : "BOSTON HCS VAMC",
    //     "institutionCode" : "523",
    //     "objectType" : "CdwClinic",
    //     "link" : [ ]


    return Backbone.Model.extend({
        MISSING_CLINIC_NAME: MISSING_CLINIC_NAME,
        MISSING_LOCATION_NAME: MISSING_LOCATION_NAME,

        idAttribute: 'clinicId',

        getClinicName: function() {
            return this.get('clinicName') || MISSING_CLINIC_NAME;
        },

        getFriendlyLocationName: function() {
            return this.get('clinicFriendlyLocationName') || MISSING_LOCATION_NAME;
        },
    });
});
